/* $Id: data.c,v 1.8 1998/07/20 21:05:56 ericb Exp $ */
/* Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Taken from E1431 library, heavily modified by Eric Backus */

/* This file groups all the functions associated with the data
   subsystem. */

#include "sema.h"

SHORTSIZ16 EXPORT
e1432_set_data_format(E1432ID hw, SHORTSIZ16 ID, LONGSIZ32 blocksize,
		      SHORTSIZ16 datasize, SHORTSIZ16 mode,
		      SHORTSIZ16 append)
{
    SHORTSIZ16 error;

    TRACE_PRINTF(0, ("e1432_set_data_format(0x%p, "
		     "%d, %ld, %d, %d, %d)\n",
		     hw, ID, blocksize, datasize, mode, append));

    error = e1432_set_blocksize(hw, ID, blocksize);
    if (error)
	return error;

    error = e1432_set_data_size(hw, ID, datasize);
    if (error)
	return error;

    error = e1432_set_data_mode(hw, ID, mode);
    if (error)
	return error;

    error = e1432_set_append_status(hw, ID, append);
    if (error)
	return error;

    return 0;
}
